// pages/api/debug/whoami.ts
import type { NextApiRequest, NextApiResponse } from "next";
import { getServerSession } from "next-auth";
import { authOptions } from "@/lib/authOptions";

export default async function handler(
  req: NextApiRequest,
  res: NextApiResponse
) {
  const session = await getServerSession(req, res, authOptions);
  res.status(200).json({
    ok: true,
    session,
    note: "If session.user is null, you are NOT logged in for this request origin.",
  });
}
